<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Required meta tags start -->
    <!-- <base href="https://khedmatpishraft.ir/network/portal/" /> -->
    <base href="https://khedmatpishraft.ir/network/portal/" />
    <meta http-equiv="Content-Type" content="text/html;charset=UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <title>پنل ثبت مسئولین ستادهای انتخاباتی دکتر قالیباف</title>
    <!-- Required meta tags end -->

    <!-- plugins:css start-->
    <link rel="stylesheet" href="assets/css/dx.light.css" />
    <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
    <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
    <!-- plugins:css end-->

    <!-- Plugin css for this page -->
    <link rel="stylesheet" href="assets/vendors/select2/select2.min.css" />
    <link rel="stylesheet" href="assets/vendors/select2-bootstrap-theme/select2-bootstrap.min.css" />
    <!-- End plugin css for this page -->

    <!-- Layout styles start -->
    <link rel="stylesheet" href="assets/css/style.css" />
    <!-- End layout styles -->

    <!-- fav icon page start -->
    <link rel="shortcut icon" href="assets/images/bg/05.png" />
    <!-- End fav icon page -->

    <style>
    a,
    abbr,
    acronym,
    address,
    applet,
    article,
    aside,
    audio,
    b,
    big,
    blockquote,
    body,
    canvas,
    caption,
    center,
    cite,
    code,
    dd,
    del,
    details,
    dfn,
    div,
    dl,
    dt,
    em,
    embed,
    fieldset,
    figcaption,
    figure,
    footer,
    form,
    h1,
    h2,
    h3,
    h4,
    h5,
    h6,
    header,
    hgroup,
    html,
    i,
    iframe,
    img,
    ins,
    kbd,
    label,
    legend,
    li,
    mark,
    menu,
    nav,
    object,
    ol,
    output,
    p,
    pre,
    q,
    ruby,
    s,
    samp,
    section,
    small,
    span,
    strike,
    strong,
    sub,
    summary,
    sup,
    table,
    tbody,
    td,
    tfoot,
    th,
    thead,
    time,
    tr,
    tt,
    u,
    ul,
    var,
    video {
        margin: 0;
        padding: 0;
        border: 0;
        font-size: 100%;
        vertical-align: baseline;
    }

    article,
    aside,
    details,
    figcaption,
    figure,
    footer,
    header,
    hgroup,
    menu,
    nav,
    section {
        display: block;
    }

    body {
        line-height: 1;
    }

    ol,
    ul {
        list-style: none;
    }

    blockquote,
    q {
        quotes: none;
    }

    blockquote:after,
    blockquote:before,
    q:after,
    q:before {
        content: "";
        content: none;
    }

    table {
        border-collapse: collapse;
        border-spacing: 0;
    }

    :root {
        --background: #f5f5f5;
        --brand-color: #fff;
        --color: #202020;
        --color-smooth: #606060;
        --color-white: #f5f5f5;
        --blue: #2155cd;
        --blue-50: #2155cd80;
        --blue-hover: #396be2;
        --blue-hover-50: #396be280;
        --item-bg: #eee;
        --item-border: #d6d6d6;
        --shadow: rgba(0, 0, 0, 0.1);
        --submit-shadow: rgba(33, 85, 205, 0.25);
    }

    * {
        font-family: yekanbakh;
    }

    *,
    :after,
    :before {
        box-sizing: border-box;
    }

    html {
        font-size: 16px;
    }

    @media screen and (max-width: 768px) {
        html {
            font-size: 15px;
        }
    }

    @media screen and (max-width: 465px) {
        html {
            font-size: 14px;
        }
    }

    body {
        min-width: 100%;
        min-height: 100%;
        height: 100vh;
        background-color: var(--background);
    }

    .page-hero {
        max-height: 100vh;
        max-width: 100vw;
        overflow: hidden;
    }

    .login-page {
        display: flex;
        justify-content: center;
    }

    .prewiev-hero {
        width: 50vw;
        display: flex;
        align-items: center;
        justify-content: center;

        background-color: var(--brand-color);
    }

    .prewiev-hero img {
        width: 100%;
        height: 100%;
        object-fit: contain;
        object-position: left bottom;
    }

    .form-hero {
        width: 50vw;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-direction: column;
        padding: 1.5rem;
        gap: 2rem;
    }

    .form-head {
        display: flex;
        align-items: center;
        justify-content: center;
        flex-direction: column;
        gap: 1rem;
    }

    .logo {
        width: 7rem;
        height: 7rem;
        padding: 1.5rem;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        background-color: #f2f3f7;
    }

    .login-title {
        font-size: 1.2rem !important;
        font-weight: 600;
        text-align: right;
        line-height: 1.5;
        color: var(--color);
        direction: rtl;
    }

    .form {
        display: flex;
        align-items: center;
        justify-content: center;
        flex-direction: column;
        gap: 0.5rem;
        width: 400px;
        max-width: 90%;
    }

    .input-hero {
        width: 100%;
        height: 40px;
        position: relative;
        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    .input-hero input {
        width: 100%;
        height: 100%;
        display: block;
        top: 0;
        right: 0;
        position: absolute;
        font-weight: 500;
        font-size: 1rem;
        color: var(--color);
        border-radius: 0.5rem;
        border: 0.125rem solid var(--item-border);
        background: var(--background);
        padding: 0.5rem 1rem 0.5rem 3rem;
        transition: all 0.25s ease 0s;
        font-family: yekan !important;
    }

    .input-hero input:focus {
        border-color: var(--blue-50);
        outline: 0;
    }

    .input-name {
        right: 1rem;
        position: relative;
        display: block;
        z-index: 2;
        transition: all 0.25s ease 0s;
        top: 0;
        color: var(--color-smooth);
    }

    .input-hero input:focus+.input-name {
        top: -1.1rem !important;
        background-color: #fff;
        padding: 0 0.2rem;
        color: var(--blue);
    }

    .input-hero input:valid+.input-name {
        top: -1.1rem !important;
        background-color: #fff;
        padding: 0 0.2rem;
    }

    .input-icon {
        position: relative;
        left: 0.5rem;
        z-index: 2;
        color: var(--color-smooth);
        transition: all 0.25s ease 0s;
    }

    .input-hero input:focus+.input-name+.input-icon {
        color: var(--blue);
    }

    .input-icon svg {
        vertical-align: middle;
        width: 1.5rem;
        height: 1.5rem;
    }

    .password-input {
        margin-bottom: 0.5rem;
    }

    .recovery-password {
        position: relative;
        right: 0;
        color: var(--blue);
    }

    .checkbox-hero {
        width: 100%;
        align-items: flex-start;
        color: var(--color-smooth);
        font-size: 1rem;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    .checkbox-hero input {
        display: none;
    }

    .checkbox-cover {
        width: 1.5rem;
        height: 1.5rem;
        display: inline-block;
        background: var(--item-bg);
        border-radius: 0.5rem;
        border: 0.125rem solid var(--item-border);
        transition: all 0.25s ease 0s;
        cursor: pointer;
    }

    .checkbox-hero input:checked+.checkbox-cover {
        border-color: var(--blue);
        border-width: 0.4rem;
    }

    .submit-btn {
        width: 100%;
        height: 40px;
        font-weight: 500;
        font-size: 1rem;
        color: var(--color-white);
        border-radius: 0.5rem;
        transition: all 0.25s ease 0s;
        box-shadow: inset 1px 1px 3px var(--shadow);
        background: var(--green);
        border: 1px solid var(--green-50);
        cursor: pointer;
        box-shadow: 0px 10px 10px var(0, 0, 0, 0.5);
        transition: all 0.25s ease 0s;
    }

    .submit-btn:hover {
        background: var(--blue-hover);
        border: 1px solid var(--blue-hover-50);
    }

    .form-bottom {
        position: fixed;
        bottom: 1rem;
        color: var(--color-smooth);
        font-size: 1rem;
        font-weight: 500;
    }

    .form-bottom a {
        color: var(--blue);
    }

    @media screen and (max-width: 768px) {
        .prewiev-hero {
            display: none;
        }

        .form-hero {
            width: 100vw;
        }
    }

    .footer {
        position: absolute;
        bottom: 0;
        right: 0
    }
    </style>
</head>

<body class="dx-viewport login-page page-hero">
    <div class="prewiev-hero">
        <img src="assets/images/bg/02.jpg" alt="Prewiev" />
    </div>

    <div class="login-form form-hero">
        <div class="form-head flex-row pb-4" dir="rtl">
            <img src="assets/images/bg/05.png" width="50" alt="" />
            <h3 class="login-title font-weight-bold aviny">پنل ثبت مسئولین ستادهای انتخاباتی دکتر قالیباف</h3>
        </div>

        <form action="verify.php" autocomplete="off" class="form" id="loginForm" dir="rtl">
            <label class="input-hero mb-3" for="phoneNumber">
                <input type="tel" name="phoneNumber" id="phoneNumber" maxlength="11" pattern="09[0-9]{9}"
                    inputmode="numeric" required />
                <span class="input-name"> شماره موبایل </span>
                <span class="input-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 50 50" width="30">
                        <path
                            d="M15 1C13.35503 1 12 2.3550302 12 4L12 46C12 47.64497 13.35503 49 15 49L35 49C36.64497 49 38 47.64497 38 46L38 4C38 2.3550302 36.64497 1 35 1L15 1 z M 15 3L23.333984 3L23.683594 4.0507812C23.872594 4.6177813 24.403 5 25 5C25.597 5 26.127406 4.6177813 26.316406 4.0507812L26.666016 3L35 3C35.56503 3 36 3.4349698 36 4L36 46C36 46.56503 35.56503 47 35 47L15 47C14.43497 47 14 46.56503 14 46L14 4C14 3.4349698 14.43497 3 15 3 z"
                            fill="#606060" />
                    </svg>
                </span>
            </label>


            <button name="login" type="submit" class="submit-btn btn" id="submitButton" disabled>ارسال کد</button>
        </form>
    </div>


    <!-- partial:../../partials/_footer.html start-->
    <footer class="footer pt-2 pb-2" dir="rtl">
        <div class="d-sm-flex justify-content-center justify-content-sm-between font-weight-bold">
            <span class="text-muted text-center text-sm-left d-block d-sm-inline-block">
                هرگونه کپی از این پلتفرم ملزم به اخذ مجوز از واحد فناوری اطلاعات سامانه می باشد.
            </span>
        </div>
    </footer>
    <!-- partial footer end -->

    <!-- plugins:js -->
    <script src="assets/vendors/js/vendor.bundle.base.js"></script>
    <!-- plugins:js end -->

    <!-- Plugin js for this page -->
    <script src="assets/vendors/select2/select2.min.js"></script>
    <script src="assets/vendors/typeahead.js/typeahead.bundle.min.js"></script>
    <!-- End plugin js for this page -->

    <!-- inject:js -->
    <script src="assets/js/off-canvas.js"></script>
    <script src="assets/js/hoverable-collapse.js"></script>
    <script src="assets/js/misc.js"></script>
    <script src="assets/js/settings.js"></script>
    <script src="assets/js/todolist.js"></script>
    <!-- endinject -->
    <script src="assets/js/dx.all.js"></script>
    <script src="assets/data/data.js"></script>
    <script>
    $("#phoneNumber").on("keyup", function() {
        if ($('form')[0].checkValidity()) {
            $("#submitButton").removeAttr("disabled")
        } else {
            $("#submitButton").attr("disabled")
        }
    })
    </script>
</body>

</html>