let allDocs = [{
    docId: '000001',
    enabeld: false,
    balance: 0,
    status: 'تایید شده',
    creditor: 12000000,
    debtor: 12000000,
    date: '1400/01/06',
}, {
    docId: '000002',
    enabeld: true,
    balance: 500000,
    status: 'پیش نویس',
    creditor: 8000000,
    debtor: 8500000,
    date: '1400/01/13',
}, {
    docId: '000003',
    enabeld: true,
    balance: 0,
    status: 'موقت',
    creditor: 22500000,
    debtor: 22550000,
    date: '1400/01/07',
}, {
    docId: '000004',
    enabeld: true,
    balance: -100000,
    status: 'پیش نویس',
    creditor: 18650000,
    debtor: 19650000,
    date: '1400/01/03',
}, {
    docId: '000005',
    enabeld: true,
    balance: -200000,
    status: 'پیش نویس',
    creditor: 9000000,
    debtor: 8800000,
    date: '1400/01/10',
}, {
    docId: '000006',
    enabeld: true,
    balance: 0,
    status: 'موقت',
    creditor: 52600000,
    debtor: 52600000,
    date: '1400/01/17',
}, {
    docId: '000007',
    enabeld: false,
    balance: 0,
    status: 'تایید شده',
    creditor: 37900000,
    debtor: 37900000,
    date: '1400/01/21',
}, {
    docId: '000008',
    enabeld: true,
    balance: 10000000,
    status: 'پیش نویس',
    creditor: 21400000,
    debtor: 31400000,
    date: '1400/01/01',
}, {
    docId: '000009',
    enabeld: false,
    balance: 0,
    status: 'تایید شده',
    creditor: 61750000,
    debtor: 61750000,
    date: '1400/01/24',
}, {
    docId: '000010',
    enabeld: true,
    balance: 0,
    status: 'موقت',
    creditor: 45750000,
    debtor: 45750000,
    date: '1400/01/11',
}, {
    docId: '000011',
    enabeld: false,
    balance: 0,
    status: 'تایید شده',
    creditor: 3680000,
    debtor: 3680000,
    date: '1400/01/12',
}];

let documentData = {
    docId: '000001',
    status: 'تایید شده',
    creditor: 12000000,
    debtor: 12000000,
    balance: 0,
    date: '1400/01/06',
    description: `توضیحات`,
    data: [
        {
            num: 01,
            id: '000000001',
            description: 'اجاره رقبه 20029917000001',
            explanation: 'شرح یک',
            creditor: 8000000,
            debtor: 0,
            moein: 'اجاره رقبات موقوفه',
            general: 'درآمد'
        }, {
            num: 02,
            id: '000000002',
            description: 'هزینه کارشناسی دادگستری آقای فلانی',
            explanation: 'شرح دو از مورد ششم در فصل هشتم',
            creditor: 0,
            debtor: 8000000,
            moein: 'هزینه کارشناسی',
            general: 'هزینه'
        }, {
            num: 03,
            id: '000000003',
            description: 'تنخواه دار 1',
            explanation: 'شرح سوم از دهم',
            creditor: 10000000,
            debtor: 0,
            moein: 'تنخواه دار',
            general: 'تنخواه'
        }, {
            num: 04,
            id: '000000004',
            description: 'تنخواه دار 1',
            explanation: 'شرح سوم از دهم',
            creditor: 0,
            debtor: 10000000,
            moein: 'تنخواه دار',
            general: 'تنخواه'
        }, {
            num: 05,
            id: '000000005',
            description: 'صندوق 1',
            explanation: 'شرح پنجم',
            creditor: 900000,
            debtor: 0,
            moein: 'صندوق 1',
            general: 'صندوق'
        }, {
            num: 06,
            id: '000000006',
            description: 'صندوق 1',
            explanation: 'شرح پنجم',
            creditor: 0,
            debtor: 900000,
            moein: 'صندوق 1',
            general: 'صندوق'
        }
    ]
}

for (let i = 0; i < documentData.data.length; i++) {
    documentData.data[i].account = documentData.data[i].general + ' - ' + documentData.data[i].moein + ' - ' + documentData.data[i].description;
}

let documentDataForm = {
    docId: '',
    status: '',
    creditor: 0,
    debtor: 0,
    balance: 0,
    date: '',
    description: ``,
    data: [
        {
            num: 01,
            id: '',
            description: '',
            explanation: '',
            creditor: 0,
            debtor: 0,
            moein: '',
            general: ''
        }, {
            num: 02,
            id: '',
            description: '',
            explanation: '',
            creditor: 0,
            debtor: 0,
            moein: '',
            general: ''
        }, {
            num: 03,
            id: '',
            description: '',
            explanation: '',
            creditor: 0,
            debtor: 0,
            moein: '',
            general: ''
        }, {
            num: 04,
            id: '',
            description: '',
            explanation: '',
            creditor: 0,
            debtor: 0,
            moein: '',
            general: ''
        }, {
            num: 05,
            id: '',
            description: '',
            explanation: '',
            creditor: 0,
            debtor: 0,
            moein: '',
            general: ''
        }, {
            num: 06,
            id: '',
            description: '',
            explanation: '',
            creditor: 0,
            debtor: 0,
            moein: '',
            general: ''
        }
    ]
}

const fontStyles = [
    {
        icon: 'add',
        style: 'bold',
        hint: 'افزودن سند',
        link: 'newdoc.html',
        disabled: false,
        type: 'success'
    },
    {
        icon: 'edit',
        style: 'bold',
        hint: 'ویرایش سند',
        link: 'newdoc.html',
        disabled: true,
        type: 'default'
    },
    {
        icon: 'trash',
        style: 'bold',
        hint: 'حذف سند',
        disabled: true,
        type: 'danger'
    },
    {
        icon: 'fullscreen',
        style: 'bold',
        hint: 'نمایش سند',
        link: 'newdoc.html',
        disabled: true,
        type: 'normal'
    },
];

const fontStylesPayableDoc = [
    {
        icon: 'edit',
        style: 'bold',
        hint: 'ویرایش سند',
        link: 'newpayabledoc.html',
        type: 'default'
    },
    {
        icon: 'add',
        style: 'bold',
        hint: 'افزودن سند',
        link: 'newpayabledoc.html',
        type: 'success'
    },
    {
        icon: 'fullscreen',
        style: 'bold',
        hint: 'نمایش سند',
        link: 'newpayabledoc.html',
        type: 'normal'
    },
];

const fontStylesReceivableDoc = [
    {
        icon: 'edit',
        style: 'bold',
        hint: 'ویرایش سند',
        link: 'newreceivabledoc.html',
        type: 'default'
    },
    {
        icon: 'add',
        style: 'bold',
        hint: 'افزودن سند',
        link: 'newreceivabledoc.html',
        type: 'success'
    },
    {
        icon: 'fullscreen',
        style: 'bold',
        hint: 'نمایش سند',
        link: 'newreceivabledoc.html',
        type: 'normal'
    },
];

const fontStylesNewDoc = [
    {
        icon: 'save',
        style: 'bold',
        hint: 'ذخیره سند',
        type: 'success'
    },
    {
        icon: 'return',
        style: 'bold',
        hint: 'لغو و بازگشت',
        link: 'index.html',
        type: 'danger',
    }
];

const fontStylesNewPayableDoc = [
    {
        icon: 'save',
        style: 'bold',
        hint: 'ذخیره سند',
        type: 'success'
    },
    {
        icon: 'return',
        style: 'bold',
        hint: 'لغو و بازگشت',
        link: 'payable-documents.html',
        type: 'danger',
    }
];

const fontStylesNewReceivableDoc = [
    {
        icon: 'save',
        style: 'bold',
        hint: 'ذخیره سند',
        type: 'success'
    },
    {
        icon: 'return',
        style: 'bold',
        hint: 'لغو و بازگشت',
        link: 'receivable-documents.html',
        type: 'danger',
    }
];

const fontStylesNewAcc = [
    {
        icon: 'save',
        style: 'bold',
        hint: 'تعریف حساب',
        type: 'success'
    }
];

let subAccount = [
    'دارایی جاری',
    'دارایی غیر جاری',
    'بدهی جاری',
    'بدهی غیر جاری',
    'هزینه عملیاتی',
    'هزینه غیر عملیاتی',
    'درآمد عملیاتی',
    'درآمد غیر عملیاتی',
    'انتظامی'
];


let account = [
    {
        id: 10,
        title: 'دارایی',
        subAccount: [
            'دارایی جاری',
            'دارایی غیر جاری'
        ]
    },
    {
        id: 20,
        title: 'بدهی',
        subAccount: [
            'بدهی جاری',
            'بدهی غیر جاری'
        ]
    },
    {
        id: 30,
        title: 'انتظامی (تراز)',
        subAccount: [
            'انتظامی'
        ]
    },
    {
        id: 40,
        title: 'هزینه',
        subAccount: [
            'هزینه عملیاتی',
            'هزینه غیر عملیاتی'
        ]
    },
    {
        id: 50,
        title: 'درآمد',
        subAccount: [
            'درآمد عملیاتی',
            'درآمد غیر عملیاتی'
        ]
    },
    {
        id: 60,
        title: 'انتظامی (حساب)',
        subAccount: [
            'انتظامی'
        ]
    }
];


let generals = [
    {
        'id': 101,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'صندوق'
    },
    {
        'id': 102,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'بانک'
    },
    {
        'id': 103,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'تنخواه'
    },
    {
        'id': 104,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'اسناد دریافتنی'
    },
    {
        'id': 105,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'سرمایه گذاری ها'
    },
    {
        'id': 106,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'مطالبات (بدهکاران)'
    },
    {
        'id': 107,
        'account': account[0].title,
        'subAccount': account[0].subAccount[1],
        'title': 'دارایی های ثابت'
    },
    {
        'id': 108,
        'account': account[0].title,
        'subAccount': account[0].subAccount[1],
        'title': 'سرمایه گذاری مدت دار'
    },
    {
        'id': 201,
        'account': account[1].title,
        'subAccount': account[1].subAccount[0],
        'title': 'اسناد پرداختنی'
    },
    {
        'id': 202,
        'account': account[1].title,
        'subAccount': account[1].subAccount[0],
        'title': 'پیش دریافت ها'
    },
    {
        'id': 203,
        'account': account[1].title,
        'subAccount': account[1].subAccount[0],
        'title': 'ودایع مستاجران'
    },
    {
        'id': 204,
        'account': account[1].title,
        'subAccount': account[1].subAccount[0],
        'title': 'تبدیل به احسن'
    },
    {
        'id': 205,
        'account': account[1].title,
        'subAccount': account[1].subAccount[1],
        'title': 'حساب ها و اسناد پرداختنی بلند مدت'
    },
    {
        'id': 206,
        'account': account[1].title,
        'subAccount': account[1].subAccount[1],
        'title': 'وام پرداختنی'
    },
    {
        'id': 207,
        'account': account[1].title,
        'subAccount': account[1].subAccount[1],
        'title': 'ذخیره مزایای پایان خدمت کارکنان'
    },
    {
        'id': 301,
        'account': account[2].title,
        'subAccount': account[2].subAccount[0],
        'title': 'تراز افتتاحیه'
    },
    {
        'id': 302,
        'account': account[2].title,
        'subAccount': account[2].subAccount[0],
        'title': 'تراز اختتامیه'
    },
    {
        'id': 303,
        'account': account[2].title,
        'subAccount': account[2].subAccount[0],
        'title': 'عملکرد سود و زیان'
    },
    {
        'id': 401,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه حفظ عین'
    },
    {
        'id': 402,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه اجرای نیت'
    },
    {
        'id': 501,
        'account': account[4].title,
        'subAccount': account[4].subAccount[0],
        'title': 'درآمد'
    },
    {
        'id': 502,
        'account': account[4].title,
        'subAccount': account[4].subAccount[1],
        'title': 'درآمد'
    },
    {
        'id': 601,
        'account': account[5].title,
        'subAccount': account[5].subAccount[0],
        'title': 'حساب های انتظامی'
    },
    {
        'id': 602,
        'account': account[5].title,
        'subAccount': account[5].subAccount[0],
        'title': 'طرف حساب های انتظامی'
    },
];


let moeins = [
    {
        'id': 1101,
        'parent': 101,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'صندوق 1'
    },
    {
        'id': 1201,
        'parent': 102,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'بانک صادرات'
    },
    {
        'id': 1202,
        'parent': 102,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'بانک شهر'
    },
    {
        'id': 1301,
        'parent': 103,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'تنخواه دار'
    },
    {
        'id': 1401,
        'parent': 104,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'چک دریافتنی'
    },
    {
        'id': 1501,
        'parent': 105,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'سپرده کوتاه مدت'
    },
    // {
    //     'id': 1501,
    //     'parent': 105,
    //     'account': account[0].title,
    //     'subAccount': account[0].subAccount[0],
    //     'title': 'اوراق مشارکت'
    // },
    // {
    //     'id': 1502,
    //     'parent': 105,
    //     'account': account[0].title,
    //     'subAccount': account[0].subAccount[0],
    //     'title': 'سپرده های بانکی'
    // },
    // {
    //     'id': 1503,
    //     'parent': 105,
    //     'account': account[0].title,
    //     'subAccount': account[0].subAccount[0],
    //     'title': 'پروژه های مشارکتی'
    // },
    // {
    //     'id': 1504,
    //     'parent': 105,
    //     'account': account[0].title,
    //     'subAccount': account[0].subAccount[0],
    //     'title': 'سهام'
    // },
    {
        'id': 1601,
        'parent': 106,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'تسهیلات اعطایی (وام)'
    },
    {
        'id': 1602,
        'parent': 106,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'ودایع پرداختی موقوفه'
    },
    {
        'id': 1603,
        'parent': 106,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'اجور معوقه'
    },
    {
        'id': 1604,
        'parent': 106,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'بدهکاران موقت'
    },
    {
        'id': 1701,
        'parent': 107,
        'account': account[0].title,
        'subAccount': account[0].subAccount[1],
        'title': 'زمین'
    },
    {
        'id': 1702,
        'parent': 107,
        'account': account[0].title,
        'subAccount': account[0].subAccount[1],
        'title': 'ساختمان'
    },
    {
        'id': 1703,
        'parent': 107,
        'account': account[0].title,
        'subAccount': account[0].subAccount[1],
        'title': 'اثاثیه'
    },
    {
        'id': 1704,
        'parent': 107,
        'account': account[0].title,
        'subAccount': account[0].subAccount[1],
        'title': 'وسائط نقلیه'
    },
    {
        'id': 1705,
        'parent': 107,
        'account': account[0].title,
        'subAccount': account[0].subAccount[1],
        'title': 'امتیاز تلفن'
    },
    {
        'id': 1801,
        'parent': 108,
        'account': account[0].title,
        'subAccount': account[0].subAccount[1],
        'title': 'اوراق مشارکت'
    },
    {
        'id': 1802,
        'parent': 108,
        'account': account[0].title,
        'subAccount': account[0].subAccount[1],
        'title': 'سپرده های مدت دار بانکی'
    },
    {
        'id': 1803,
        'parent': 108,
        'account': account[0].title,
        'subAccount': account[0].subAccount[1],
        'title': 'پروژه های مشارکتی'
    },
    {
        'id': 1804,
        'parent': 108,
        'account': account[0].title,
        'subAccount': account[0].subAccount[1],
        'title': 'سهام'
    },
    {
        'id': 2101,
        'parent': 201,
        'account': account[1].title,
        'subAccount': account[1].subAccount[0],
        'title': 'چک'
    },
    {
        'id': 2201,
        'parent': 202,
        'account': account[1].title,
        'subAccount': account[1].subAccount[0],
        'title': 'پیش دریافت قرارداد'
    },
    {
        'id': 2202,
        'parent': 202,
        'account': account[1].title,
        'subAccount': account[1].subAccount[0],
        'title': 'سایر پیش دریافت ها'
    },
    {
        'id': 2301,
        'parent': 203,
        'account': account[1].title,
        'subAccount': account[1].subAccount[0],
        'title': 'ودیعه رقبات موقوفه'
    },
    {
        'id': 2302,
        'parent': 203,
        'account': account[1].title,
        'subAccount': account[1].subAccount[0],
        'title': 'ودیعه اموال موقوفه'
    },
    {
        'id': 2401,
        'parent': 204,
        'account': account[1].title,
        'subAccount': account[1].subAccount[0],
        'title': 'تبدیل به احسن رقبات'
    },
    {
        'id': 2402,
        'parent': 204,
        'account': account[1].title,
        'subAccount': account[1].subAccount[0],
        'title': 'تبدیل به احسن اموال و دارایی های موقوفه'
    },
    {
        'id': 2501,
        'parent': 205,
        'account': account[1].title,
        'subAccount': account[1].subAccount[1],
        'title': 'حساب های پرداختنی بلند مدت'
    },
    {
        'id': 2601,
        'parent': 206,
        'account': account[1].title,
        'subAccount': account[1].subAccount[1],
        'title': 'وام بانکی'
    },
    {
        'id': 2701,
        'parent': 207,
        'account': account[1].title,
        'subAccount': account[1].subAccount[1],
        'title': 'ذخیره مزایای پایان خدمت کارکنان '
    },
    {
        'id': 4101,
        'parent': 401,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه کارشناسی'
    },
    {
        'id': 4102,
        'parent': 401,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه حق الوکاله وکیل '
    },
    {
        'id': 4103,
        'parent': 401,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه حقوق و دستمزد'
    },
    {
        'id': 4104,
        'parent': 401,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه حق ماموریت و اضافه کاری'
    },
    {
        'id': 4105,
        'parent': 401,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه انشعابات مصرفی'
    },
    // {
    //     'id': 4107,
    //     'parent': 401,
    //     'account': account[3].title,
    //     'subAccount': account[3].subAccount[0],
    //     'title': 'هزینه برگزاری مراسم'
    // },
    // {
    //     'id': 4108,
    //     'parent': 401,
    //     'account': account[3].title,
    //     'subAccount': account[3].subAccount[0],
    //     'title': 'هزینه کمک بلاعوض'
    // },
    {
        'id': 4106,
        'parent': 401,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه ایاب و ذهاب'
    },
    {
        'id': 4107,
        'parent': 401,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه خرید ملزومات مصرفی دفتر'
    },
    {
        'id': 4108,
        'parent': 401,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه فعالیت های عمرانی و ساختمانی'
    },
    {
        'id': 4109,
        'parent': 401,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه فعالیت های آموزشی، تبلیغاتی'
    },
    {
        'id': 4110,
        'parent': 401,
        'account': account[3].title,
        'subAccount': account[3].subAccount[1],
        'title': 'هزینه خدمات بانکی'
    },
    {
        'id': 4111,
        'parent': 401,
        'account': account[3].title,
        'subAccount': account[3].subAccount[1],
        'title': 'هزینه خدمات اداری'
    },
    ,
    {
        'id': 4201,
        'parent': 402,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه اجرای نیت 1'
    },
    {
        'id': 4202,
        'parent': 402,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه اجرای نیت 2'
    },
    {
        'id': 4203,
        'parent': 402,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه اجرای نیت 3'
    },
    {
        'id': 4204,
        'parent': 402,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه اجرای نیت 4'
    },
    {
        'id': 5101,
        'parent': 501,
        'account': account[4].title,
        'subAccount': account[4].subAccount[0],
        'title': 'اجاره رقبات موقوفه'
    },
    {
        'id': 5102,
        'parent': 501,
        'account': account[4].title,
        'subAccount': account[4].subAccount[0],
        'title': 'درآمد از محل پذیره '
    },
    {
        'id': 5103,
        'parent': 501,
        'account': account[4].title,
        'subAccount': account[4].subAccount[0],
        'title': 'درآمد از محل فروش حقوق موقوفه'
    },
    {
        'id': 5104,
        'parent': 501,
        'account': account[4].title,
        'subAccount': account[4].subAccount[0],
        'title': 'درآمد از محل سود سرمایه گذاری'
    },
    {
        'id': 5201,
        'parent': 502,
        'account': account[4].title,
        'subAccount': account[4].subAccount[1],
        'title': 'اجاره اموال و لوازم موقوفه'
    },
    {
        'id': 5202,
        'parent': 502,
        'account': account[4].title,
        'subAccount': account[4].subAccount[1],
        'title': 'اهدایی'
    },
    {
        'id': 6101,
        'parent': 601,
        'account': account[5].title,
        'subAccount': '',
        'title': 'دارایی های ثابت موقوفه'
    },
    {
        'id': 6102,
        'parent': 601,
        'account': account[5].title,
        'subAccount': '',
        'title': 'اموال موقوفه'
    },
    {
        'id': 6201,
        'parent': 602,
        'account': account[5].title,
        'subAccount': '',
        'title': 'دارایی های ثابت موقوفه'
    },
    {
        'id': 6202,
        'parent': 602,
        'account': account[5].title,
        'subAccount': '',
        'title': 'اموال موقوفه'
    }
];

let filterdMoein;
let filterdDescription;

let descriptions = [
    {
        'id': 1101000001,
        'parent': 1101,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'صندوق 1'
    },
    {
        'id': 1101999999,
        'parent': 1101,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'صندوق 999999'
    },
    {
        'id': 1201000001,
        'parent': 1201,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'بانک صادرات شماره حساب 0200478109004'
    },
    {
        'id': 1201999999,
        'parent': 1201,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'بانک صادرات شماره حساب 0100001075002'
    },
    {
        'id': 1202000001,
        'parent': 1202,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'بانک شهر شماره حساب 0106064883007'
    },
    {
        'id': 1202999999,
        'parent': 1202,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'بانک شهر شماره حساب 0106064883007'
    },
    {
        'id': 1301000001,
        'parent': 1301,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'تنخواه دار 1'
    },
    {
        'id': 1301999999,
        'parent': 1301,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'تنخواه دار 99'
    },
    {
        'id': 1501000001,
        'parent': 1501,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'سپرده کوتاه مدت بانک صادرات شماره حساب 0300488205004'
    },
    {
        'id': 1501000002,
        'parent': 1501,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'سپرده کوتاه مدت بانک صادرات شماره حساب 0300488205005'
    },
    // {
    //     'id': 1501000001,
    //     'parent': 1501,
    //     'account': account[0].title,
    //     'subAccount': account[0].subAccount[0],
    //     'title': 'اوراق مشارکت بانک صادرات شماره سریال 12036'
    // },
    // {
    //     'id': 1501000002,
    //     'parent': 1501,
    //     'account': account[0].title,
    //     'subAccount': account[0].subAccount[0],
    //     'title': 'اوراق مشارکت بانک صادرات شماره سریال 2036'
    // },
    // {
    //     'id': 1502000001,
    //     'parent': 1502,
    //     'account': account[0].title,
    //     'subAccount': account[0].subAccount[0],
    //     'title': 'سپرده کوتاه مدت بانک صادرات شماره حساب 0300488205004'
    // },
    // {
    //     'id': 1502000002,
    //     'parent': 1502,
    //     'account': account[0].title,
    //     'subAccount': account[0].subAccount[0],
    //     'title': 'سپرده کوتاه مدت بانک صادرات شماره حساب 0300488205005'
    // },
    // {
    //     'id': 1503000001,
    //     'parent': 1503,
    //     'account': account[0].title,
    //     'subAccount': account[0].subAccount[0],
    //     'title': 'پروژه ساخت'
    // },
    // {
    //     'id': 1504000001,
    //     'parent': 1504,
    //     'account': account[0].title,
    //     'subAccount': account[0].subAccount[0],
    //     'title': 'سهام بورسی'
    // },
    // {
    //     'id': 1504000002,
    //     'parent': 1504,
    //     'account': account[0].title,
    //     'subAccount': account[0].subAccount[1],
    //     'title': 'سهام شرکت'
    // },
    {
        'id': 1601000001,
        'parent': 1601,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'وام اعطایی به کارمندان'
    },
    {
        'id': 1601000002,
        'parent': 1601,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'وام اعطایی به اشخاص'
    },
    {
        'id': 1602000001,
        'parent': 1602,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'ودیعه مسکن 1'
    },
    {
        'id': 1602000002,
        'parent': 1602,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'ودیعه تجاری 1'
    },
    {
        'id': 1603000001,
        'parent': 1603,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'اجور معوقه رقبه 20029917000001'
    },
    {
        'id': 16030000002,
        'parent': 1603,
        'account': account[0].title,
        'subAccount': account[0].subAccount[0],
        'title': 'اجور معوقه رقبه 20029917000002'
    },
    {
        'id': 1701000001,
        'parent': 1701,
        'account': account[0].title,
        'subAccount': account[0].subAccount[1],
        'title': 'زمین 1'
    },
    {
        'id': 1701000002,
        'parent': 1701,
        'account': account[0].title,
        'subAccount': account[0].subAccount[1],
        'title': 'زمین 2'
    },
    {
        'id': 1702000001,
        'parent': 1702,
        'account': account[0].title,
        'subAccount': account[0].subAccount[1],
        'title': 'ساختمان 1'
    },
    {
        'id': 1702000002,
        'parent': 1702,
        'account': account[0].title,
        'subAccount': account[0].subAccount[1],
        'title': 'ساختمان 2'
    },
    {
        'id': 1703000001,
        'parent': 1703,
        'account': account[0].title,
        'subAccount': account[0].subAccount[1],
        'title': 'اثاثیه 1'
    },
    {
        'id': 1703000002,
        'parent': 1703,
        'account': account[0].title,
        'subAccount': account[0].subAccount[1],
        'title': 'اثاثیه 2'
    },
    {
        'id': 1704000001,
        'parent': 1704,
        'account': account[0].title,
        'subAccount': account[0].subAccount[1],
        'title': 'وسیله نقلیه 1'
    },
    {
        'id': 1704000002,
        'parent': 1704,
        'account': account[0].title,
        'subAccount': account[0].subAccount[1],
        'title': 'وسیله نقلیه 2'
    },
    {
        'id': 1705000001,
        'parent': 1705,
        'account': account[0].title,
        'subAccount': account[0].subAccount[1],
        'title': 'تلفن 1'
    },
    {
        'id': 1801000001,
        'parent': 1801,
        'account': account[0].title,
        'subAccount': account[0].subAccount[1],
        'title': 'اوراق مشارکت بانک صادرات شماره سریال 12036'
    },
    {
        'id': 1801000002,
        'parent': 1801,
        'account': account[0].title,
        'subAccount': account[0].subAccount[1],
        'title': 'اوراق مشارکت بانک صادرات شماره سریال 2036'
    },
    {
        'id': 1802000001,
        'parent': 1802,
        'account': account[0].title,
        'subAccount': account[0].subAccount[1],
        'title': 'سپرده بلند مدت بانک صادرات شماره حساب 0300488205004'
    },
    {
        'id': 1802000002,
        'parent': 1802,
        'account': account[0].title,
        'subAccount': account[0].subAccount[1],
        'title': 'سپرده بلند مدت بانک صادرات شماره حساب 0300488205005'
    },
    {
        'id': 1803000001,
        'parent': 1803,
        'account': account[0].title,
        'subAccount': account[0].subAccount[1],
        'title': 'پروژه ساخت'
    },
    {
        'id': 1804000001,
        'parent': 1804,
        'account': account[0].title,
        'subAccount': account[0].subAccount[1],
        'title': 'سهام بورسی'
    },
    {
        'id': 1804000002,
        'parent': 1804,
        'account': account[0].title,
        'subAccount': account[0].subAccount[1],
        'title': 'سهام شرکت'
    },    
    {
        'id': 2101000001,
        'parent': 2101,
        'account': account[1].title,
        'subAccount': account[1].subAccount[0],
        'title': 'چک پرداختی 1'
    },
    {
        'id': 2201000001,
        'parent': 2201,
        'account': account[1].title,
        'subAccount': account[1].subAccount[0],
        'title': 'پیش دریافت قرارداد 1'
    },
    {
        'id': 2201000002,
        'parent': 2201,
        'account': account[1].title,
        'subAccount': account[1].subAccount[0],
        'title': 'پیش دریافت قرارداد 2'
    },
    {
        'id': 2301000001,
        'parent': 2301,
        'account': account[1].title,
        'subAccount': account[1].subAccount[0],
        'title': 'ودیعه رقبه 20029917000001'
    },
    {
        'id': 2301000002,
        'parent': 2301,
        'account': account[1].title,
        'subAccount': account[1].subAccount[0],
        'title': 'ودیعه رقبه 20029917000002'
    },
    {
        'id': 2302000001,
        'parent': 2302,
        'account': account[1].title,
        'subAccount': account[1].subAccount[0],
        'title': 'ودیعه ساختمان 1'
    },
    {
        'id': 2302000002,
        'parent': 2302,
        'account': account[1].title,
        'subAccount': account[1].subAccount[0],
        'title': 'ودیعه وسیله نقلیه بطور مثال'
    },
    {
        'id': 2401000001,
        'parent': 2401,
        'account': account[1].title,
        'subAccount': account[1].subAccount[0],
        'title': 'فروش بخشی از رقبه 20029917000001'
    },
    {
        'id': 2401000002,
        'parent': 2401,
        'account': account[1].title,
        'subAccount': account[1].subAccount[0],
        'title': 'فروش رقبه 20029917000002'
    },
    {
        'id': 2402000001,
        'parent': 2402,
        'account': account[1].title,
        'subAccount': account[1].subAccount[0],
        'title': 'تبدیل به احسن اثاثیه اداری موقوفه'
    },
    {
        'id': 2501000001,
        'parent': 2501,
        'account': account[1].title,
        'subAccount': account[1].subAccount[1],
        'title': 'پرداخت بلند مدت'
    },
    {
        'id': 2601000001,
        'parent': 2601,
        'account': account[1].title,
        'subAccount': account[1].subAccount[1],
        'title': 'وام دریافتی از بانک صادرات'
    },
    {
        'id': 2701000001,
        'parent': 2701,
        'account': account[1].title,
        'subAccount': account[1].subAccount[1],
        'title': 'ذخیره مزایای آقای فلان'
    },
    // {
    //     'id': 4101000001,
    //     'parent': 4101,
    //     'account': account[3].title,
    //     'subAccount': account[3].subAccount[0],
    //     'title': 'نیت 1'
    // },
    // {
    //     'id': 4101000002,
    //     'parent': 4101,
    //     'account': account[3].title,
    //     'subAccount': account[3].subAccount[0],
    //     'title': 'نیت 2'
    // },
    // {
    //     'id': 4101000003,
    //     'parent': 4101,
    //     'account': account[3].title,
    //     'subAccount': account[3].subAccount[0],
    //     'title': 'نیت 3'
    // },
    {
        'id': 4101000001,
        'parent': 4101,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه کارشناس دادگستری آقای فالنی'
    },
    {
        'id': 4102000001,
        'parent': 4102,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه حق الوکاله آقای جعفری'
    },
    {
        'id': 4103000001,
        'parent': 4103,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'حق الزحمه آقای 1'
    },
    {
        'id': 4104000001,
        'parent': 4104,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه حق مأموریت آقای 1'
    },
    {
        'id': 4104000002,
        'parent': 4104,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه اضافه کاری آقای  2'
    },
    {
        'id': 4105000001,
        'parent': 4105,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه قبض تلفن 1'
    },
    {
        'id': 4105000002,
        'parent': 4105,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه قبض برق دفتر'
    },
    {
        'id': 4105000003,
        'parent': 4105,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه قبض گاز دفتر'
    },
    // {
    //     'id': 4107000001,
    //     'parent': 4107,
    //     'account': account[3].title,
    //     'subAccount': account[3].subAccount[0],
    //     'title': 'هزینه برگزاری جشن نیمه شعبان'
    // },
    // {
    //     'id': 4108000001,
    //     'parent': 4108,
    //     'account': account[3].title,
    //     'subAccount': account[3].subAccount[0],
    //     'title': 'هزینه کمک به محرومین'
    // },
    // {
    //     'id': 4108000002,
    //     'parent': 4108,
    //     'account': account[3].title,
    //     'subAccount': account[3].subAccount[0],
    //     'title': 'هزینه کمک به دفتر مراجع تقلید'
    // },
    {
        'id': 4106000001,
        'parent': 4106,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه پیک موتوری'
    },
    {
        'id': 4106000002,
        'parent': 4106,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه باربری'
    },
    {
        'id': 4106000003,
        'parent': 4106,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه آژانس'
    },
    {
        'id': 4107000001,
        'parent': 4107,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه خرید لوازم مصرفی آبدارخانه'
    },
    {
        'id': 4107000002,
        'parent': 4107,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه خرید نوشت افزار دفتر'
    },
    {
        'id': 4108000001,
        'parent': 4108,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه خرید مصالح ساختمانی'
    },
    {
        'id': 4108000002,
        'parent': 4108,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه خرید لوازم بنایی و ساختمانی'
    },
    {
        'id': 4108000003,
        'parent': 4108,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه خرید و تعمیر تاسیسات برودتی'
    },
    {
        'id': 4108000004,
        'parent': 4108,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه خرید و تعمیر تاسیسات برقی'
    },
    {
        'id': 4108000005,
        'parent': 4108,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه خرید و تعمیر تاسیسات گرمایشی'
    },
    {
        'id': 4108000006,
        'parent': 4108,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه خرید و تعمیر تاسیسات و لوله کشی'
    },
    {
        'id': 4108000007,
        'parent': 4108,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه تعمیر و نگهداری لوازم'
    },
    {
        'id': 4109000001,
        'parent': 4109,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه فعالیت های آموزشی'
    },
    {
        'id': 4109000002,
        'parent': 4109,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه فعالیت های مذهبی'
    },
    {
        'id': 4109000003,
        'parent': 4109,
        'account': account[3].title,
        'subAccount': account[3].subAccount[0],
        'title': 'هزینه فعالیت های فرهنگی'
    },

    {
        'id': 4110000001,
        'parent': 4110,
        'account': account[3].title,
        'subAccount': account[3].subAccount[1],
        'title': 'هزینه کارمزد خدمات بانکی '
    },
    {
        'id': 4111000001,
        'parent': 4111,
        'account': account[3].title,
        'subAccount': account[3].subAccount[1],
        'title': 'هزینه های خدمات اداری'
    },

    {
        'id': 5101000001,
        'parent': 5101,
        'account': account[4].title,
        'subAccount': account[4].subAccount[0],
        'title': 'اجاره رقبه 20029917000001'
    },
    {
        'id': 5101000002,
        'parent': 5101,
        'account': account[4].title,
        'subAccount': account[4].subAccount[0],
        'title': 'اجاره رقبه 20029917000002'
    },    
    {
        'id': 5101000003,
        'parent': 5101,
        'account': account[4].title,
        'subAccount': account[4].subAccount[0],
        'title': 'اجاره رقبه 20029917000003'
    },
    {
        'id': 5102000001,
        'parent': 5102,
        'account': account[4].title,
        'subAccount': account[4].subAccount[0],
        'title': 'درآمد از محل پذیره تمدید'
    },
    {
        'id': 5102000002,
        'parent': 5102,
        'account': account[4].title,
        'subAccount': account[4].subAccount[0],
        'title': 'درآمد از محل پذیره تفکیک'
    },    
    {
        'id': 5102000003,
        'parent': 5102,
        'account': account[4].title,
        'subAccount': account[4].subAccount[0],
        'title': 'درآمد از محل پذیره نقل و انتقال'
    },
    {
        'id': 5102000004,
        'parent': 5102,
        'account': account[4].title,
        'subAccount': account[4].subAccount[0],
        'title': 'درآمد از محل پذیره افراز'
    },    
    {
        'id': 5102000005,
        'parent': 5102,
        'account': account[4].title,
        'subAccount': account[4].subAccount[0],
        'title': 'در آمد از محل پذیره'
    },    
    {
        'id': 5103000001,
        'parent': 5103,
        'account': account[4].title,
        'subAccount': account[4].subAccount[0],
        'title': 'فروش حق تملک اعیان'
    },
    {
        'id': 5103000002,
        'parent': 5103,
        'account': account[4].title,
        'subAccount': account[4].subAccount[0],
        'title': 'فروش حق ریشه'
    },   
    {
        'id': 5103000003,
        'parent': 5103,
        'account': account[4].title,
        'subAccount': account[4].subAccount[0],
        'title': 'فروش حق سرقفلی'
    },  
    {
        'id': 5104000001,
        'parent': 5104,
        'account': account[4].title,
        'subAccount': account[4].subAccount[0],
        'title': 'درآمد از محل سود سپرده'
    },
    {
        'id': 5104000002,
        'parent': 5104,
        'account': account[4].title,
        'subAccount': account[4].subAccount[0],
        'title': 'درآمد از محل سود اوراق مشارکت'
    },    
    {
        'id': 5104000003,
        'parent': 5104,
        'account': account[4].title,
        'subAccount': account[4].subAccount[0],
        'title': 'درآمد از محل سود سهام'
    },
    {
        'id': 5201000001,
        'parent': 5201,
        'account': account[4].title,
        'subAccount': account[4].subAccount[1],
        'title': 'اجاره ساختمان 1'
    },    
    {
        'id': 5201000002,
        'parent': 5201,
        'account': account[4].title,
        'subAccount': account[4].subAccount[1],
        'title': 'اجاره خودرو 1'
    },
    {
        'id': 5202000001,
        'parent': 5202,
        'account': account[4].title,
        'subAccount': account[4].subAccount[1],
        'title': 'درآمد از محل اهدای تجهیزات'
    }
];

let payableDocs = [{
    num: 1,
    docId: '000001',
    chequeId:'031540',
    status: 1,
    amount: 12000000,
    date: '1400/01/26',
    paydate: '1400/01/06',
    reciever: 'رضا میرکریمی',
    explanation: 'تست تست تست',
    outdocId: '100001',   
}, {
    num: 2,
    docId: '000002',
    chequeId:'031540',
    status: 0,
    amount: 12000000,
    date: '1400/01/26',
    paydate: '1400/01/07',
    reciever: 'رضا میرکریمی',
    explanation: 'تست تست تست',
    outdocId: '100002',
}, {
    num: 3,
    docId: '000003',
    chequeId:'031540',
    status: -1,
    amount: 12000000,
    date: '1400/01/26',
    paydate: '1400/01/08',
    reciever: 'رضا میرکریمی',
    explanation: 'تست تست تست',
    outdocId: '100003', 
}, {
    num: 4,
    docId: '000004',
    chequeId:'031540',
    status: 1,
    amount: 12000000,
    date: '1400/01/26',
    paydate: '1400/01/09',
    reciever: 'رضا میرکریمی',
    explanation: 'تست تست تست',
    outdocId: '100004', 
}, {
    num: 5,
    docId: '000005',
    chequeId:'031540',
    status: 1,
    amount: 12000000,
    date: '1400/01/26',
    paydate: '1400/01/05',
    reciever: 'رضا میرکریمی',
    explanation: 'تست تست تست',
    outdocId: '100005',
}, {
    num: 6,
    docId: '000006',
    chequeId:'031540',
    status: 1,
    amount: 12000000,
    date: '1400/01/26',
    paydate: '1399/12/28',
    reciever: 'رضا میرکریمی',
    explanation: 'تست تست تست',
    outdocId: '100006', 
}, {
    num: 7,
    docId: '000007',
    chequeId:'031540',
    status: 1,
    amount: 12000000,
    date: '1400/01/26',
    paydate: '1399/12/29',
    reciever: 'رضا میرکریمی',
    explanation: 'تست تست تست',
    outdocId: '100007', 
}, {
    num: 8,
    docId: '000008',
    chequeId:'031540',
    status: 1,
    amount: 12000000,
    date: '1400/01/26',
    paydate: '1400/01/01',
    reciever: 'رضا میرکریمی',
    explanation: 'تست تست تست',
    outdocId: '100008',
}, {
    num: 9,
    docId: '000009',
    chequeId:'031540',
    status: 1,
    amount: 12000000,
    date: '1400/01/26',
    paydate: '1400/01/10',
    reciever: 'رضا میرکریمی',
    explanation: 'تست تست تست',
    outdocId: '100009',
}, {
    num: 10,
    docId: '000010',
    chequeId:'031540',
    status: 1,
    amount: 12000000,
    date: '1400/01/26',
    paydate: '1400/01/25',
    reciever: 'رضا میرکریمی',
    explanation: 'تست تست تست',
    outdocId: '100010',
}, {
    num: 11,
    docId: '000011',
    chequeId:'031540',
    status: 1,
    amount: 12000000,
    date: '1400/01/26',
    paydate: '1400/01/26',
    reciever: 'رضا میرکریمی',
    explanation: 'تست تست تست',
    outdocId: '100011',
}];

let payableDocumentData = {
    docId: '000001',
    status: 'وصول شده',
    creditor: 12000000,
    debtor: 12000000,
    balance: 0,
    date: '1400/01/06',
    paydate: '1400/01/26',
    description: `توضیحات`,
    data: [
        {
            num: 01,
            id: '000000001',
            description: 'اجاره رقبه 20029917000001',
            explanation: 'شرح یک',
            creditor: 8000000,
            debtor: 0,
            moein: 'اجاره رقبات موقوفه',
            general: 'درآمد'
        }, {
            num: 02,
            id: '000000002',
            description: 'هزینه کارشناسی دادگستری آقای فلانی',
            explanation: 'شرح دو از مورد ششم در فصل هشتم',
            creditor: 0,
            debtor: 8000000,
            moein: 'هزینه کارشناسی',
            general: 'هزینه'
        }
    ]
}

for (let i = 0; i < payableDocumentData.data.length; i++) {
    payableDocumentData.data[i].account = payableDocumentData.data[i].general + ' - ' + payableDocumentData.data[i].moein + ' - ' + payableDocumentData.data[i].description;
}

let payableDocumentDataOutput = {
    docId: '000001',
    status: 'وصول شده',
    creditor: 12000000,
    debtor: 12000000,
    balance: 0,
    date: '1400/01/06',
    paydate: '1400/01/26',
    description: `توضیحات`,
    data: [
        {
            num: 01,
            id: '000000001',
            description: 'هزینه کارشناسی دادگستری آقای فلانی',
            explanation: 'شرح دو از مورد ششم در فصل هشتم',
            creditor: 0,
            debtor: 8000000,
            moein: 'هزینه کارشناسی',
            general: 'هزینه'
        },
        {
            num: 21,
            id: '000000002',
            description: 'اجاره رقبه 20029917000001',
            explanation: 'شرح یک',
            creditor: 8000000,
            debtor: 0,
            moein: 'اجاره رقبات موقوفه',
            general: 'درآمد'
        }
    ]
}

for (let i = 0; i < payableDocumentDataOutput.data.length; i++) {
    payableDocumentDataOutput.data[i].account = payableDocumentDataOutput.data[i].general + ' - ' + payableDocumentDataOutput.data[i].moein + ' - ' + payableDocumentDataOutput.data[i].description;
}

let documentDataPayableForm = {
    docId: '',
    status: '',
    amount: '',
    date: '',
    paydate: '',
    description: ``,
    generalReciever: '',
    moeinReciever: '',
    descriptionsReciever: '',
    generalPayer: '',
    moeinPayer: '',
    descriptionsPayer: ''
}